#include "stdafx.h"
#include "time.h"
#include "stdio.h"
#include "sys/stat.h"
#include "WsparcieKluczy.h"



//Wpisuje do klucza informacj o dysku
void WpiszInfoODysku(char *klucz)
{
	// cz zalena od sprztu - 4 bajty
	DWORD driveSerialNumber = 0;
	GetVolumeInformation("C:\\", 0, 0, &driveSerialNumber, 0, 0, 0,  0);

	// rozpraszamy informacj o dysku po kluczu
	klucz[KLUCZ_HDD_INDEKS1] = driveSerialNumber & 0xFF;
	klucz[KLUCZ_HDD_INDEKS2] = (driveSerialNumber >> 8) & 0xFF;
	klucz[KLUCZ_HDD_INDEKS3] = (driveSerialNumber >> 16) & 0xFF;
	klucz[KLUCZ_HDD_INDEKS4] = (driveSerialNumber >> 24) & 0xFF;
}

//tworzy nowy klucz aktywacyjny
char * WygenerujKluczAktywacyjny()
{
	char *klucz = new char[MAX_KLUCZ];

    // wypeniamy wartociami losowymi
    srand( (unsigned)time( NULL ) ); 
	for(int i = 0; i < MAX_KLUCZ; i++)
       klucz[i] = rand() % 255; 

	WpiszInfoODysku(klucz);

    return klucz;
}

//zapisuje cz losow klucza niezalenie od tego, czy aktywacyjnego, czy aktywacji
void ZapiszKluczAktywacyjny(char * aKlucz, const char * aNazwaPliku)
{
	srand( (unsigned)time( NULL ) ); 
	// usuwamy informacje o dysku aby nie byo atwo pozna skd bierze si ta cz klucza
	aKlucz[KLUCZ_HDD_INDEKS1] = rand() % 255;
	aKlucz[KLUCZ_HDD_INDEKS2] = rand() % 255;
	aKlucz[KLUCZ_HDD_INDEKS3] = rand() % 255;
	aKlucz[KLUCZ_HDD_INDEKS4] = rand() % 255;

	// zapisujemy do pliku
	FILE* f;
	fopen_s(&f, aNazwaPliku, "w+");
	fwrite(aKlucz, sizeof(char), MAX_KLUCZ, f);
	fclose(f);
}

bool PlikIstnieje(char * aNazwaPliku) 
{
  struct stat plikInfo;
  int iStat;

  iStat = stat(aNazwaPliku,&plikInfo);

  return (iStat == 0);
}

//odczytuje z pliku cz losow klucza aktywacyjnego i dodaje cz wyznaczan na podstawie dysku
char *OdczytajKluczAktywacyjny()
{
	char *klucz = NULL;
	// Jeli plik istnieje to go odczytujemy, jeli nie to generujemy go i zapisujemy
	if(!PlikIstnieje("klucz_aktywacyjny.dat"))
	{
		klucz = WygenerujKluczAktywacyjny();
		ZapiszKluczAktywacyjny(klucz, "klucz_aktywacyjny.dat");
	}
	else
	{
		klucz = new char[MAX_KLUCZ];
		
		// odczyt z czci losowej
		FILE* f;
		fopen_s(&f, "klucz_aktywacyjny.dat", "r");
		fread_s(klucz,MAX_KLUCZ, sizeof(char), MAX_KLUCZ, f);
		fclose(f);

		WpiszInfoODysku(klucz);
	}

	return klucz;
}

//odczytuje z pliku cz klucz aktywacji niezalen od sprztu
char *OdczytajKluczAktywacji(char * hasloWWW)
{
	char *klucz = NULL;
	if(PlikIstnieje("klucz_aktywacyjny.dat"))
	{
		klucz = new char[MAX_KLUCZ];
		
		// odczyt z czci losowej
		FILE* f;
		fopen_s(&f, "klucz_aktywacyjny.dat", "r");
		fread_s(klucz,MAX_KLUCZ, sizeof(char), MAX_KLUCZ, f);
		fclose(f);
		
		// wpisanie aktualnej informacji o dysku
		WpiszInfoODysku(klucz);
		
		const int DLUGOSC_ZACIEMNIAJACEGO = 10;
		unsigned char kluczZaciemniajacy[DLUGOSC_ZACIEMNIAJACEGO] = { 11, 22, 189, 240, 1, 111, 112, 76, 127, 44 };

		// zmiana postaci i szyfrowanie hasem www
		int dlugoscHaslaWWW = strlen(hasloWWW);
		int indeksHaslaWWW = 0;
		int indeksKluczZaciemniajacy = 0;
		for(int i = 0; i < MAX_KLUCZ; i++)
		{
            klucz[i] = klucz[i] ^ hasloWWW[indeksHaslaWWW++] ^ kluczZaciemniajacy[indeksKluczZaciemniajacy++];
			if(indeksHaslaWWW >= dlugoscHaslaWWW)
				indeksHaslaWWW = 0;
			if(indeksKluczZaciemniajacy >= DLUGOSC_ZACIEMNIAJACEGO)
				indeksKluczZaciemniajacy = 0;
		}
	}

	return klucz;
}

//konwertuje klucz binarny to szesnastkowej postaci tekstowej
char * KluczBinarnyNaTekstowy(char *klucz)
{
	char *kluczTekst = new char[MAX_KLUCZ * 2 + 1];
	strcpy_s(kluczTekst, MAX_KLUCZ * 2 + 1, "");

	for(int i = 0; i < MAX_KLUCZ; i++)
	{
		char buff[3];
		sprintf_s(buff, sizeof(buff), "%02X", (unsigned char)klucz[i]);
		strcat_s(kluczTekst, MAX_KLUCZ * 2 + 1, buff);
	}
	return kluczTekst;
}
